/**HEADER********************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: fxlc95000bsp.c$
* $Version : 1.0.0.0$
* $Date    : Feb-24-2012$
*
* Comments:
*
*   This file contains the source functions for functions required to
*   specifically initialize the card.
*
*END************************************************************************/

#include "mqx_inc.h"
#include "bsp.h"
#include "bsp_prv.h"

#include "fxlc95000bsp.h"





// *************************************************************************
// *************************************************************************
static boolean bfxl95000_FrameOverRunError = FALSE;  
volatile uint_32 bsptimer_counter32 = 0;



/*ISR*********************************************************************
*
* Function Name    : _fxl95000_GetFrameOverrun_Status
* Returned Value   : TRUE if frame error occurred
*                    FALSE if no frame error
* Comments         :
*    Retrieve frame overrun status.
*    
*    NOTE: Frameerror irq will get triggered at level 7 (non-maskable).
*
*END**********************************************************************/
boolean _fxl95000_GetFrameOverrun_Status(void)
{
  return bfxl95000_FrameOverRunError;
}

/*ISR*********************************************************************
*
* Function Name    : _fxl95000_SetFrameOverrun_Status
* Input Value      :  TRUE if frame error occurred
*                     FALSE if no frame error
* Comments         :
*    Set frame overrun status.
*    
*    NOTE: Frameerror irq will get triggered at level 7 (non-maskable).
*
*END**********************************************************************/
void _fxl95000_SetFrameOverrun_Status(boolean newstatus)
{
  bfxl95000_FrameOverRunError = newstatus;
}
// See fxlc95000bsp.h
//void _fxl95000_ClearFrameOverrun_Status(void)




// *************************************************************************
// *************************************************************************
// *************************************************************************
// Debug code



#ifdef DEBUG_ENABLE_FRAMECOUNTER  
volatile uint_32 bspframe_counter32 = 0;
#endif


#ifdef DEBUG_ENABLE_STARTOFFRAME_GPIO_TOGGLE

void _fxl95000_DebugToggle_StartDigFrame(uint_8 toggle)
{
  static volatile char bDebugToggle_InitStartDigFrame = FALSE;

  if (bDebugToggle_InitStartDigFrame == FALSE)
  {
    #define RGPIO_START_DIG_FRAME RGPIO_DATA_DATA6_MASK // DATA6 = gpio6
    //#define RGPIO_START_DIG_FRAME      RGPIO_DATA_DATA7_MASK // DATA7 = gpio7
    //#define RGPIO_START_DIG_FRAME    RGPIO_DATA_DATA14_MASK // DATA14 = gpio14

    RGPIO_DIR |= RGPIO_START_DIG_FRAME;  // RGPIOs as outputs 
    RGPIO_ENB |= RGPIO_START_DIG_FRAME;  // RGPIOs as RGPIO pins
    RGPIO_DATA |= RGPIO_START_DIG_FRAME; // RGPIOs as outputs
    
    bDebugToggle_InitStartDigFrame = TRUE;
  }
  
  if (toggle)
    RGPIO_SET = RGPIO_START_DIG_FRAME;
  else
    RGPIO_CLR = ~RGPIO_START_DIG_FRAME;
    
}
#endif


#ifdef DEBUG_ENABLE_FRAMEERROR_GPIO_TOGGLE

void _fxl95000_DebugToggle_FrameError(void)
{
  static volatile char bDebugToggle_InitFrameError = FALSE;

  if (bDebugToggle_InitFrameError == FALSE)
  {
    #define RGPIO_FRAMEERROR RGPIO_DATA_DATA4_MASK // DATA4 = gpio4

    RGPIO_DIR |= RGPIO_FRAMEERROR;  // RGPIOs as outputs 
    RGPIO_ENB |= RGPIO_FRAMEERROR;  // RGPIOs as RGPIO pins
    RGPIO_DATA |= RGPIO_FRAMEERROR; // RGPIOs as outputs
    
    bDebugToggle_InitFrameError = TRUE;
  }
  
  RGPIO_SET = RGPIO_FRAMEERROR;
  //asm { nop; nop; }
  RGPIO_CLR = ~RGPIO_FRAMEERROR;
  //asm { nop; nop; }    
}
#endif








